;Japanese Parser Selection for POPFile
;Written by Naoki iimura (amatubu@users.sourceforge.jp)

; Revised by Brian Smith (xuesheng@users.sourceforge.net)

Name "POPFile Japanese parser selector (Demo)"
Caption "$(^Name)"

;!define MUI_VERSION "0.1"

!include "MUI.nsh"
!include "StrFunc.nsh"

${StrNSISToIO}

;--------------------------------
;Configuration

  ;General
  OutFile "popfile_jpn_2.exe"
  
  ; Avoid problems on Vista
  
  RequestExecutionLevel "user"

;----------------------------------------------------------------
; Interface Settings - General Interface Settings

  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP              "pfi\hdr-common.bmp"
  !define MUI_HEADERIMAGE_RIGHT

;----------------------------------------------------------------
;  Interface Settings - Interface Resource Settings

  ; The 'hdr-common.bmp' logo is only 90 x 57 pixels, much smaller than the 150 x 57 pixel
  ; space provided by the default 'modern_headerbmpr.exe' UI, so we use a custom UI which
  ; leaves more room for the TITLE and SUBTITLE text.

  !define MUI_UI_HEADERIMAGE_RIGHT            "pfi\pfi_headerbmpr.exe"

;--------------------------------
;Modern UI Configuration

  Page custom CustomPageB CheckCustomB

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"
  
;--------------------------------
;Reserve File

  ReserveFile "ioB.ini"
  !insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
  !insertmacro MUI_RESERVEFILE_LANGDLL

;--------------------------------
;Language Strings

  !include "English.nsh"
  !include "Japanese.nsh"

;--------------------------------
;Installer Sections

Section "section test" SecCopyUI

  SectionIn RO
  
SectionEnd

;--------------------------------
;Functions

Function .onInit

  !insertmacro MUI_LANGDLL_DISPLAY

  ;Extract InstallOptions INI files
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "ioB.ini"

FunctionEnd

Function CustomPageB

  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 1" "Text" "$(Option_Kakasi)"
  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 2" "Text" "$(Option_MeCab)"
  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 3" "Text" "$(Option_Internal)"

  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 5" "Text" "$(Note)"
  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 6" "Text" "$(Link)"
  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 6" "State" "$(Link)"

  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 4" "Flags" "$(DESC_Flags)"

  ; TODO: choose the parser which is already selected in the previous version.
  ${StrNSISToIO} $0 "$(DESC_Kakasi)"
  WriteINIStr "$PLUGINSDIR\ioB.ini" "Field 4" "State" "$0"

  !insertmacro MUI_HEADER_TEXT $(HEADER_ChooseParser) $(DESC_ChooseParser)
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "ioB.ini"

FunctionEnd

Function CheckCustomB

  ReadINIStr $0 "$PLUGINSDIR\ioB.ini" "Settings" "State"

  StrCmp $0 0 done
  StrCmp $0 1 kakasi
  StrCmp $0 2 mecab
  StrCmp $0 3 internal

  Abort

kakasi:
  ReadINIStr $1 "$PLUGINSDIR\ioB.ini" "Field 4" "HWND"
  SendMessage $1 ${WM_SETTEXT} 1 "STR:$(DESC_Kakasi)"
  Abort

mecab:
  ReadINIStr $1 "$PLUGINSDIR\ioB.ini" "Field 4" "HWND"
  SendMessage $1 ${WM_SETTEXT} 1 "STR:$(DESC_MeCab)"
  Abort

internal:
  ReadINIStr $1 "$PLUGINSDIR\ioB.ini" "Field 4" "HWND"
  SendMessage $1 ${WM_SETTEXT} 1 "STR:$(DESC_Internal)"
  Abort

done:

FunctionEnd
